package io.burkard.cdk.services.lambda

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object EventInvokeConfigOptions {

  def apply(
    onSuccess: Option[software.amazon.awscdk.services.lambda.IDestination] = None,
    onFailure: Option[software.amazon.awscdk.services.lambda.IDestination] = None,
    maxEventAge: Option[software.amazon.awscdk.Duration] = None,
    retryAttempts: Option[Number] = None
  ): software.amazon.awscdk.services.lambda.EventInvokeConfigOptions =
    (new software.amazon.awscdk.services.lambda.EventInvokeConfigOptions.Builder)
      .onSuccess(onSuccess.orNull)
      .onFailure(onFailure.orNull)
      .maxEventAge(maxEventAge.orNull)
      .retryAttempts(retryAttempts.orNull)
      .build()
}
