package io.burkard.cdk.services.iot

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnAccountAuditConfigurationProps {

  def apply(
    auditCheckConfigurations: software.amazon.awscdk.services.iot.CfnAccountAuditConfiguration.AuditCheckConfigurationsProperty,
    roleArn: String,
    accountId: String,
    auditNotificationTargetConfigurations: Option[software.amazon.awscdk.services.iot.CfnAccountAuditConfiguration.AuditNotificationTargetConfigurationsProperty] = None
  ): software.amazon.awscdk.services.iot.CfnAccountAuditConfigurationProps =
    (new software.amazon.awscdk.services.iot.CfnAccountAuditConfigurationProps.Builder)
      .auditCheckConfigurations(auditCheckConfigurations)
      .roleArn(roleArn)
      .accountId(accountId)
      .auditNotificationTargetConfigurations(auditNotificationTargetConfigurations.orNull)
      .build()
}
