package io.burkard.cdk.services.iam

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnUserToGroupAddition {

  def apply(
    internalResourceId: String,
    groupName: String,
    users: List[String]
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.iam.CfnUserToGroupAddition =
    software.amazon.awscdk.services.iam.CfnUserToGroupAddition.Builder
      .create(stackCtx, internalResourceId)
      .groupName(groupName)
      .users(users.asJava)
      .build()
}
