package io.burkard.cdk.services.greengrass.cfnFunctionDefinition

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object EnvironmentProperty {

  def apply(
    variables: Option[AnyRef] = None,
    execution: Option[software.amazon.awscdk.services.greengrass.CfnFunctionDefinition.ExecutionProperty] = None,
    resourceAccessPolicies: Option[List[_]] = None,
    accessSysfs: Option[Boolean] = None
  ): software.amazon.awscdk.services.greengrass.CfnFunctionDefinition.EnvironmentProperty =
    (new software.amazon.awscdk.services.greengrass.CfnFunctionDefinition.EnvironmentProperty.Builder)
      .variables(variables.orNull)
      .execution(execution.orNull)
      .resourceAccessPolicies(resourceAccessPolicies.map(_.asJava).orNull)
      .accessSysfs(accessSysfs.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .build()
}
