package io.burkard.cdk.services.ec2

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object BlockDevice {

  def apply(
    volume: software.amazon.awscdk.services.ec2.BlockDeviceVolume,
    deviceName: String,
    mappingEnabled: Option[Boolean] = None
  ): software.amazon.awscdk.services.ec2.BlockDevice =
    (new software.amazon.awscdk.services.ec2.BlockDevice.Builder)
      .volume(volume)
      .deviceName(deviceName)
      .mappingEnabled(mappingEnabled.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .build()
}
