package io.burkard.cdk.services.docdb

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnDBSubnetGroup {

  def apply(
    internalResourceId: String,
    dbSubnetGroupDescription: String,
    subnetIds: List[String],
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    dbSubnetGroupName: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.docdb.CfnDBSubnetGroup =
    software.amazon.awscdk.services.docdb.CfnDBSubnetGroup.Builder
      .create(stackCtx, internalResourceId)
      .dbSubnetGroupDescription(dbSubnetGroupDescription)
      .subnetIds(subnetIds.asJava)
      .tags(tags.map(_.asJava).orNull)
      .dbSubnetGroupName(dbSubnetGroupName.orNull)
      .build()
}
