package io.burkard.cdk.services.dms

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnCertificate {

  def apply(
    internalResourceId: String,
    certificatePem: Option[String] = None,
    certificateIdentifier: Option[String] = None,
    certificateWallet: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.dms.CfnCertificate =
    software.amazon.awscdk.services.dms.CfnCertificate.Builder
      .create(stackCtx, internalResourceId)
      .certificatePem(certificatePem.orNull)
      .certificateIdentifier(certificateIdentifier.orNull)
      .certificateWallet(certificateWallet.orNull)
      .build()
}
