package io.burkard.cdk.services.dlm.cfnLifecyclePolicy

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object EventParametersProperty {

  def apply(
    snapshotOwner: List[String],
    eventType: String,
    descriptionRegex: Option[String] = None
  ): software.amazon.awscdk.services.dlm.CfnLifecyclePolicy.EventParametersProperty =
    (new software.amazon.awscdk.services.dlm.CfnLifecyclePolicy.EventParametersProperty.Builder)
      .snapshotOwner(snapshotOwner.asJava)
      .eventType(eventType)
      .descriptionRegex(descriptionRegex.orNull)
      .build()
}
