package io.burkard.cdk.services.dlm.cfnLifecyclePolicy

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CrossRegionCopyRuleProperty {

  def apply(
    encrypted: Boolean,
    copyTags: Option[Boolean] = None,
    cmkArn: Option[String] = None,
    retainRule: Option[software.amazon.awscdk.services.dlm.CfnLifecyclePolicy.CrossRegionCopyRetainRuleProperty] = None,
    deprecateRule: Option[software.amazon.awscdk.services.dlm.CfnLifecyclePolicy.CrossRegionCopyDeprecateRuleProperty] = None,
    targetRegion: Option[String] = None,
    target: Option[String] = None
  ): software.amazon.awscdk.services.dlm.CfnLifecyclePolicy.CrossRegionCopyRuleProperty =
    (new software.amazon.awscdk.services.dlm.CfnLifecyclePolicy.CrossRegionCopyRuleProperty.Builder)
      .encrypted(encrypted)
      .copyTags(copyTags.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .cmkArn(cmkArn.orNull)
      .retainRule(retainRule.orNull)
      .deprecateRule(deprecateRule.orNull)
      .targetRegion(targetRegion.orNull)
      .target(target.orNull)
      .build()
}
