package io.burkard.cdk.services.backup

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object BackupPlanRule {

  def apply(
    ruleName: Option[String] = None,
    backupVault: Option[software.amazon.awscdk.services.backup.IBackupVault] = None,
    startWindow: Option[software.amazon.awscdk.Duration] = None,
    moveToColdStorageAfter: Option[software.amazon.awscdk.Duration] = None,
    completionWindow: Option[software.amazon.awscdk.Duration] = None,
    deleteAfter: Option[software.amazon.awscdk.Duration] = None,
    scheduleExpression: Option[software.amazon.awscdk.services.events.Schedule] = None
  ): software.amazon.awscdk.services.backup.BackupPlanRule =
    software.amazon.awscdk.services.backup.BackupPlanRule.Builder
      .create()
      .ruleName(ruleName.orNull)
      .backupVault(backupVault.orNull)
      .startWindow(startWindow.orNull)
      .moveToColdStorageAfter(moveToColdStorageAfter.orNull)
      .completionWindow(completionWindow.orNull)
      .deleteAfter(deleteAfter.orNull)
      .scheduleExpression(scheduleExpression.orNull)
      .build()
}
