package io.burkard.cdk.services.autoscaling

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnWarmPoolProps {

  def apply(
    autoScalingGroupName: String,
    minSize: Option[Number] = None,
    maxGroupPreparedCapacity: Option[Number] = None,
    poolState: Option[String] = None
  ): software.amazon.awscdk.services.autoscaling.CfnWarmPoolProps =
    (new software.amazon.awscdk.services.autoscaling.CfnWarmPoolProps.Builder)
      .autoScalingGroupName(autoScalingGroupName)
      .minSize(minSize.orNull)
      .maxGroupPreparedCapacity(maxGroupPreparedCapacity.orNull)
      .poolState(poolState.orNull)
      .build()
}
