package io.burkard.cdk.services.athena.cfnWorkGroup

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object WorkGroupConfigurationProperty {

  def apply(
    enforceWorkGroupConfiguration: Option[Boolean] = None,
    publishCloudWatchMetricsEnabled: Option[Boolean] = None,
    resultConfiguration: Option[software.amazon.awscdk.services.athena.CfnWorkGroup.ResultConfigurationProperty] = None,
    requesterPaysEnabled: Option[Boolean] = None,
    bytesScannedCutoffPerQuery: Option[Number] = None,
    engineVersion: Option[software.amazon.awscdk.services.athena.CfnWorkGroup.EngineVersionProperty] = None
  ): software.amazon.awscdk.services.athena.CfnWorkGroup.WorkGroupConfigurationProperty =
    (new software.amazon.awscdk.services.athena.CfnWorkGroup.WorkGroupConfigurationProperty.Builder)
      .enforceWorkGroupConfiguration(enforceWorkGroupConfiguration.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .publishCloudWatchMetricsEnabled(publishCloudWatchMetricsEnabled.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .resultConfiguration(resultConfiguration.orNull)
      .requesterPaysEnabled(requesterPaysEnabled.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .bytesScannedCutoffPerQuery(bytesScannedCutoffPerQuery.orNull)
      .engineVersion(engineVersion.orNull)
      .build()
}
