package io.burkard.cdk.services.appsync.cfnGraphQLApi

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object OpenIDConnectConfigProperty {

  def apply(
    issuer: Option[String] = None,
    authTtl: Option[Number] = None,
    iatTtl: Option[Number] = None,
    clientId: Option[String] = None
  ): software.amazon.awscdk.services.appsync.CfnGraphQLApi.OpenIDConnectConfigProperty =
    (new software.amazon.awscdk.services.appsync.CfnGraphQLApi.OpenIDConnectConfigProperty.Builder)
      .issuer(issuer.orNull)
      .authTtl(authTtl.orNull)
      .iatTtl(iatTtl.orNull)
      .clientId(clientId.orNull)
      .build()
}
