package io.burkard.cdk.services.appsync

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnApiKeyProps {

  def apply(
    apiId: String,
    description: Option[String] = None,
    expires: Option[Number] = None,
    apiKeyId: Option[String] = None
  ): software.amazon.awscdk.services.appsync.CfnApiKeyProps =
    (new software.amazon.awscdk.services.appsync.CfnApiKeyProps.Builder)
      .apiId(apiId)
      .description(description.orNull)
      .expires(expires.orNull)
      .apiKeyId(apiKeyId.orNull)
      .build()
}
