package io.burkard.cdk.services.appmesh.cfnVirtualNode

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ClientPolicyTlsProperty {

  def apply(
    validation: software.amazon.awscdk.services.appmesh.CfnVirtualNode.TlsValidationContextProperty,
    ports: Option[List[_ <: Number]] = None,
    certificate: Option[software.amazon.awscdk.services.appmesh.CfnVirtualNode.ClientTlsCertificateProperty] = None,
    enforce: Option[Boolean] = None
  ): software.amazon.awscdk.services.appmesh.CfnVirtualNode.ClientPolicyTlsProperty =
    (new software.amazon.awscdk.services.appmesh.CfnVirtualNode.ClientPolicyTlsProperty.Builder)
      .validation(validation)
      .ports(ports.map(_.asJava).orNull)
      .certificate(certificate.orNull)
      .enforce(enforce.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .build()
}
