package io.burkard.cdk.services.apigateway

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object StageOptions {

  def apply(
    methodOptions: Option[Map[String, _ <: software.amazon.awscdk.services.apigateway.MethodDeploymentOptions]] = None,
    throttlingBurstLimit: Option[Number] = None,
    clientCertificateId: Option[String] = None,
    description: Option[String] = None,
    tracingEnabled: Option[Boolean] = None,
    documentationVersion: Option[String] = None,
    variables: Option[Map[String, String]] = None,
    dataTraceEnabled: Option[Boolean] = None,
    cacheClusterEnabled: Option[Boolean] = None,
    loggingLevel: Option[software.amazon.awscdk.services.apigateway.MethodLoggingLevel] = None,
    stageName: Option[String] = None,
    throttlingRateLimit: Option[Number] = None,
    cacheDataEncrypted: Option[Boolean] = None,
    cacheTtl: Option[software.amazon.awscdk.Duration] = None,
    cachingEnabled: Option[Boolean] = None,
    accessLogFormat: Option[software.amazon.awscdk.services.apigateway.AccessLogFormat] = None,
    accessLogDestination: Option[software.amazon.awscdk.services.apigateway.IAccessLogDestination] = None,
    metricsEnabled: Option[Boolean] = None,
    cacheClusterSize: Option[String] = None
  ): software.amazon.awscdk.services.apigateway.StageOptions =
    (new software.amazon.awscdk.services.apigateway.StageOptions.Builder)
      .methodOptions(methodOptions.map(_.asJava).orNull)
      .throttlingBurstLimit(throttlingBurstLimit.orNull)
      .clientCertificateId(clientCertificateId.orNull)
      .description(description.orNull)
      .tracingEnabled(tracingEnabled.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .documentationVersion(documentationVersion.orNull)
      .variables(variables.map(_.asJava).orNull)
      .dataTraceEnabled(dataTraceEnabled.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .cacheClusterEnabled(cacheClusterEnabled.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .loggingLevel(loggingLevel.orNull)
      .stageName(stageName.orNull)
      .throttlingRateLimit(throttlingRateLimit.orNull)
      .cacheDataEncrypted(cacheDataEncrypted.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .cacheTtl(cacheTtl.orNull)
      .cachingEnabled(cachingEnabled.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .accessLogFormat(accessLogFormat.orNull)
      .accessLogDestination(accessLogDestination.orNull)
      .metricsEnabled(metricsEnabled.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .cacheClusterSize(cacheClusterSize.orNull)
      .build()
}
