package io.burkard.cdk.services.apigateway

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object Method {

  def apply(
    internalResourceId: String,
    resource: software.amazon.awscdk.services.apigateway.IResource,
    httpMethod: String,
    options: Option[software.amazon.awscdk.services.apigateway.MethodOptions] = None,
    integration: Option[software.amazon.awscdk.services.apigateway.Integration] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.apigateway.Method =
    software.amazon.awscdk.services.apigateway.Method.Builder
      .create(stackCtx, internalResourceId)
      .resource(resource)
      .httpMethod(httpMethod)
      .options(options.orNull)
      .integration(integration.orNull)
      .build()
}
