package io.burkard.cdk.services.voiceid

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnDomainProps {

  def apply(
    name: String,
    serverSideEncryptionConfiguration: software.amazon.awscdk.services.voiceid.CfnDomain.ServerSideEncryptionConfigurationProperty,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    description: Option[String] = None
  ): software.amazon.awscdk.services.voiceid.CfnDomainProps =
    (new software.amazon.awscdk.services.voiceid.CfnDomainProps.Builder)
      .name(name)
      .serverSideEncryptionConfiguration(serverSideEncryptionConfiguration)
      .tags(tags.map(_.asJava).orNull)
      .description(description.orNull)
      .build()
}
