package io.burkard.cdk.services.synthetics

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnCanary {

  def apply(
    internalResourceId: String,
    name: String,
    artifactS3Location: String,
    code: software.amazon.awscdk.services.synthetics.CfnCanary.CodeProperty,
    runtimeVersion: String,
    executionRoleArn: String,
    schedule: software.amazon.awscdk.services.synthetics.CfnCanary.ScheduleProperty,
    startCanaryAfterCreation: Boolean,
    successRetentionPeriod: Option[Number] = None,
    visualReference: Option[software.amazon.awscdk.services.synthetics.CfnCanary.VisualReferenceProperty] = None,
    runConfig: Option[software.amazon.awscdk.services.synthetics.CfnCanary.RunConfigProperty] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    failureRetentionPeriod: Option[Number] = None,
    vpcConfig: Option[software.amazon.awscdk.services.synthetics.CfnCanary.VPCConfigProperty] = None,
    artifactConfig: Option[software.amazon.awscdk.services.synthetics.CfnCanary.ArtifactConfigProperty] = None,
    deleteLambdaResourcesOnCanaryDeletion: Option[Boolean] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.synthetics.CfnCanary =
    software.amazon.awscdk.services.synthetics.CfnCanary.Builder
      .create(stackCtx, internalResourceId)
      .name(name)
      .artifactS3Location(artifactS3Location)
      .code(code)
      .runtimeVersion(runtimeVersion)
      .executionRoleArn(executionRoleArn)
      .schedule(schedule)
      .startCanaryAfterCreation(startCanaryAfterCreation)
      .successRetentionPeriod(successRetentionPeriod.orNull)
      .visualReference(visualReference.orNull)
      .runConfig(runConfig.orNull)
      .tags(tags.map(_.asJava).orNull)
      .failureRetentionPeriod(failureRetentionPeriod.orNull)
      .vpcConfig(vpcConfig.orNull)
      .artifactConfig(artifactConfig.orNull)
      .deleteLambdaResourcesOnCanaryDeletion(deleteLambdaResourcesOnCanaryDeletion.map(Boolean.box).orNull)
      .build()
}
