package io.burkard.cdk.services.servicecatalog

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object TagOptions {

  def apply(
    internalResourceId: String,
    allowedValuesForTags: Map[String, _ <: List[String]]
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.servicecatalog.TagOptions =
    software.amazon.awscdk.services.servicecatalog.TagOptions.Builder
      .create(stackCtx, internalResourceId)
      .allowedValuesForTags(allowedValuesForTags.mapValues(_.asJava).toMap.asJava)
      .build()
}
