package io.burkard.cdk.services.servicecatalog

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object StackSetsConstraintOptions {

  def apply(
    executionRoleName: String,
    regions: List[String],
    adminRole: software.amazon.awscdk.services.iam.IRole,
    accounts: List[String],
    messageLanguage: Option[software.amazon.awscdk.services.servicecatalog.MessageLanguage] = None,
    description: Option[String] = None,
    allowStackSetInstanceOperations: Option[Boolean] = None
  ): software.amazon.awscdk.services.servicecatalog.StackSetsConstraintOptions =
    (new software.amazon.awscdk.services.servicecatalog.StackSetsConstraintOptions.Builder)
      .executionRoleName(executionRoleName)
      .regions(regions.asJava)
      .adminRole(adminRole)
      .accounts(accounts.asJava)
      .messageLanguage(messageLanguage.orNull)
      .description(description.orNull)
      .allowStackSetInstanceOperations(allowStackSetInstanceOperations.map(Boolean.box).orNull)
      .build()
}
