package io.burkard.cdk.services.servicecatalog

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnPortfolioShare {

  def apply(
    internalResourceId: String,
    portfolioId: String,
    accountId: String,
    acceptLanguage: Option[String] = None,
    shareTagOptions: Option[Boolean] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.servicecatalog.CfnPortfolioShare =
    software.amazon.awscdk.services.servicecatalog.CfnPortfolioShare.Builder
      .create(stackCtx, internalResourceId)
      .portfolioId(portfolioId)
      .accountId(accountId)
      .acceptLanguage(acceptLanguage.orNull)
      .shareTagOptions(shareTagOptions.map(Boolean.box).orNull)
      .build()
}
