package io.burkard.cdk.services.servicecatalog

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnPortfolioProductAssociationProps {

  def apply(
    portfolioId: String,
    productId: String,
    acceptLanguage: Option[String] = None,
    sourcePortfolioId: Option[String] = None
  ): software.amazon.awscdk.services.servicecatalog.CfnPortfolioProductAssociationProps =
    (new software.amazon.awscdk.services.servicecatalog.CfnPortfolioProductAssociationProps.Builder)
      .portfolioId(portfolioId)
      .productId(productId)
      .acceptLanguage(acceptLanguage.orNull)
      .sourcePortfolioId(sourcePortfolioId.orNull)
      .build()
}
