package io.burkard.cdk.services.servicecatalog

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnPortfolioPrincipalAssociation {

  def apply(
    internalResourceId: String,
    principalArn: String,
    principalType: String,
    portfolioId: String,
    acceptLanguage: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.servicecatalog.CfnPortfolioPrincipalAssociation =
    software.amazon.awscdk.services.servicecatalog.CfnPortfolioPrincipalAssociation.Builder
      .create(stackCtx, internalResourceId)
      .principalArn(principalArn)
      .principalType(principalType)
      .portfolioId(portfolioId)
      .acceptLanguage(acceptLanguage.orNull)
      .build()
}
