package io.burkard.cdk.services.sagemaker

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnDomain {

  def apply(
    internalResourceId: String,
    authMode: String,
    subnetIds: List[String],
    vpcId: String,
    domainName: String,
    defaultUserSettings: software.amazon.awscdk.services.sagemaker.CfnDomain.UserSettingsProperty,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    domainSettings: Option[software.amazon.awscdk.services.sagemaker.CfnDomain.DomainSettingsProperty] = None,
    appNetworkAccessType: Option[String] = None,
    kmsKeyId: Option[String] = None,
    appSecurityGroupManagement: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.sagemaker.CfnDomain =
    software.amazon.awscdk.services.sagemaker.CfnDomain.Builder
      .create(stackCtx, internalResourceId)
      .authMode(authMode)
      .subnetIds(subnetIds.asJava)
      .vpcId(vpcId)
      .domainName(domainName)
      .defaultUserSettings(defaultUserSettings)
      .tags(tags.map(_.asJava).orNull)
      .domainSettings(domainSettings.orNull)
      .appNetworkAccessType(appNetworkAccessType.orNull)
      .kmsKeyId(kmsKeyId.orNull)
      .appSecurityGroupManagement(appSecurityGroupManagement.orNull)
      .build()
}
