package io.burkard.cdk.services.s3

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object LifecycleRule {

  def apply(
    abortIncompleteMultipartUploadAfter: Option[software.amazon.awscdk.Duration] = None,
    tagFilters: Option[Map[String, _]] = None,
    expirationDate: Option[java.time.Instant] = None,
    noncurrentVersionExpiration: Option[software.amazon.awscdk.Duration] = None,
    noncurrentVersionTransitions: Option[List[_ <: software.amazon.awscdk.services.s3.NoncurrentVersionTransition]] = None,
    prefix: Option[String] = None,
    objectSizeGreaterThan: Option[Number] = None,
    expiredObjectDeleteMarker: Option[Boolean] = None,
    enabled: Option[Boolean] = None,
    transitions: Option[List[_ <: software.amazon.awscdk.services.s3.Transition]] = None,
    id: Option[String] = None,
    noncurrentVersionsToRetain: Option[Number] = None,
    expiration: Option[software.amazon.awscdk.Duration] = None,
    objectSizeLessThan: Option[Number] = None
  ): software.amazon.awscdk.services.s3.LifecycleRule =
    (new software.amazon.awscdk.services.s3.LifecycleRule.Builder)
      .abortIncompleteMultipartUploadAfter(abortIncompleteMultipartUploadAfter.orNull)
      .tagFilters(tagFilters.map(_.asJava).orNull)
      .expirationDate(expirationDate.orNull)
      .noncurrentVersionExpiration(noncurrentVersionExpiration.orNull)
      .noncurrentVersionTransitions(noncurrentVersionTransitions.map(_.asJava).orNull)
      .prefix(prefix.orNull)
      .objectSizeGreaterThan(objectSizeGreaterThan.orNull)
      .expiredObjectDeleteMarker(expiredObjectDeleteMarker.map(Boolean.box).orNull)
      .enabled(enabled.map(Boolean.box).orNull)
      .transitions(transitions.map(_.asJava).orNull)
      .id(id.orNull)
      .noncurrentVersionsToRetain(noncurrentVersionsToRetain.orNull)
      .expiration(expiration.orNull)
      .objectSizeLessThan(objectSizeLessThan.orNull)
      .build()
}
