package io.burkard.cdk.services.personalize.cfnSolution

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object SolutionConfigProperty {

  def apply(
    eventValueThreshold: Option[String] = None,
    algorithmHyperParameters: Option[Map[String, String]] = None,
    autoMlConfig: Option[AnyRef] = None,
    featureTransformationParameters: Option[Map[String, String]] = None,
    hpoConfig: Option[AnyRef] = None
  ): software.amazon.awscdk.services.personalize.CfnSolution.SolutionConfigProperty =
    (new software.amazon.awscdk.services.personalize.CfnSolution.SolutionConfigProperty.Builder)
      .eventValueThreshold(eventValueThreshold.orNull)
      .algorithmHyperParameters(algorithmHyperParameters.map(_.asJava).orNull)
      .autoMlConfig(autoMlConfig.orNull)
      .featureTransformationParameters(featureTransformationParameters.map(_.asJava).orNull)
      .hpoConfig(hpoConfig.orNull)
      .build()
}
