package io.burkard.cdk.services.personalize

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnDatasetProps {

  def apply(
    name: String,
    schemaArn: String,
    datasetGroupArn: String,
    datasetType: String,
    datasetImportJob: Option[software.amazon.awscdk.services.personalize.CfnDataset.DatasetImportJobProperty] = None
  ): software.amazon.awscdk.services.personalize.CfnDatasetProps =
    (new software.amazon.awscdk.services.personalize.CfnDatasetProps.Builder)
      .name(name)
      .schemaArn(schemaArn)
      .datasetGroupArn(datasetGroupArn)
      .datasetType(datasetType)
      .datasetImportJob(datasetImportJob.orNull)
      .build()
}
