package io.burkard.cdk.services.networkmanager

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnVpcAttachment {

  def apply(
    internalResourceId: String,
    subnetArns: Option[List[String]] = None,
    vpcArn: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    options: Option[software.amazon.awscdk.services.networkmanager.CfnVpcAttachment.VpcOptionsProperty] = None,
    coreNetworkId: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.networkmanager.CfnVpcAttachment =
    software.amazon.awscdk.services.networkmanager.CfnVpcAttachment.Builder
      .create(stackCtx, internalResourceId)
      .subnetArns(subnetArns.map(_.asJava).orNull)
      .vpcArn(vpcArn.orNull)
      .tags(tags.map(_.asJava).orNull)
      .options(options.orNull)
      .coreNetworkId(coreNetworkId.orNull)
      .build()
}
