package io.burkard.cdk.services.networkmanager

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnSiteToSiteVpnAttachment {

  def apply(
    internalResourceId: String,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    coreNetworkId: Option[String] = None,
    vpnConnectionArn: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.networkmanager.CfnSiteToSiteVpnAttachment =
    software.amazon.awscdk.services.networkmanager.CfnSiteToSiteVpnAttachment.Builder
      .create(stackCtx, internalResourceId)
      .tags(tags.map(_.asJava).orNull)
      .coreNetworkId(coreNetworkId.orNull)
      .vpnConnectionArn(vpnConnectionArn.orNull)
      .build()
}
