package io.burkard.cdk.services.networkmanager

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnCoreNetworkProps {

  def apply(
    globalNetworkId: String,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    description: Option[String] = None,
    policyDocument: Option[AnyRef] = None
  ): software.amazon.awscdk.services.networkmanager.CfnCoreNetworkProps =
    (new software.amazon.awscdk.services.networkmanager.CfnCoreNetworkProps.Builder)
      .globalNetworkId(globalNetworkId)
      .tags(tags.map(_.asJava).orNull)
      .description(description.orNull)
      .policyDocument(policyDocument.orNull)
      .build()
}
