package io.burkard.cdk.services.networkmanager

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnConnectAttachmentProps {

  def apply(
    transportAttachmentId: Option[String] = None,
    edgeLocation: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    options: Option[software.amazon.awscdk.services.networkmanager.CfnConnectAttachment.ConnectAttachmentOptionsProperty] = None,
    coreNetworkId: Option[String] = None
  ): software.amazon.awscdk.services.networkmanager.CfnConnectAttachmentProps =
    (new software.amazon.awscdk.services.networkmanager.CfnConnectAttachmentProps.Builder)
      .transportAttachmentId(transportAttachmentId.orNull)
      .edgeLocation(edgeLocation.orNull)
      .tags(tags.map(_.asJava).orNull)
      .options(options.orNull)
      .coreNetworkId(coreNetworkId.orNull)
      .build()
}
