package io.burkard.cdk.services.logs

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object QueryString {

  def apply(
    stats: Option[String] = None,
    filter: Option[String] = None,
    parse: Option[String] = None,
    fields: Option[List[String]] = None,
    sort: Option[String] = None,
    limit: Option[Number] = None,
    display: Option[String] = None
  ): software.amazon.awscdk.services.logs.QueryString =
    software.amazon.awscdk.services.logs.QueryString.Builder
      .create()
      .stats(stats.orNull)
      .filter(filter.orNull)
      .parse(parse.orNull)
      .fields(fields.map(_.asJava).orNull)
      .sort(sort.orNull)
      .limit(limit.orNull)
      .display(display.orNull)
      .build()
}
