package io.burkard.cdk.services.logs

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object QueryDefinition {

  def apply(
    internalResourceId: String,
    queryDefinitionName: String,
    queryString: software.amazon.awscdk.services.logs.QueryString,
    logGroups: Option[List[_ <: software.amazon.awscdk.services.logs.ILogGroup]] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.logs.QueryDefinition =
    software.amazon.awscdk.services.logs.QueryDefinition.Builder
      .create(stackCtx, internalResourceId)
      .queryDefinitionName(queryDefinitionName)
      .queryString(queryString)
      .logGroups(logGroups.map(_.asJava).orNull)
      .build()
}
