package io.burkard.cdk.services.logs

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnMetricFilterProps {

  def apply(
    logGroupName: String,
    metricTransformations: List[_],
    filterPattern: String
  ): software.amazon.awscdk.services.logs.CfnMetricFilterProps =
    (new software.amazon.awscdk.services.logs.CfnMetricFilterProps.Builder)
      .logGroupName(logGroupName)
      .metricTransformations(metricTransformations.asJava)
      .filterPattern(filterPattern)
      .build()
}
