package io.burkard.cdk.services.lambda.eventsources

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object SelfManagedKafkaEventSource {

  def apply(
    bootstrapServers: List[String],
    secret: Option[software.amazon.awscdk.services.secretsmanager.ISecret] = None,
    authenticationMethod: Option[software.amazon.awscdk.services.lambda.eventsources.AuthenticationMethod] = None,
    batchSize: Option[Number] = None,
    enabled: Option[Boolean] = None,
    vpcSubnets: Option[software.amazon.awscdk.services.ec2.SubnetSelection] = None,
    maxBatchingWindow: Option[software.amazon.awscdk.Duration] = None,
    vpc: Option[software.amazon.awscdk.services.ec2.IVpc] = None,
    startingPosition: Option[software.amazon.awscdk.services.lambda.StartingPosition] = None,
    topic: Option[String] = None,
    securityGroup: Option[software.amazon.awscdk.services.ec2.ISecurityGroup] = None
  ): software.amazon.awscdk.services.lambda.eventsources.SelfManagedKafkaEventSource =
    software.amazon.awscdk.services.lambda.eventsources.SelfManagedKafkaEventSource.Builder
      .create()
      .bootstrapServers(bootstrapServers.asJava)
      .secret(secret.orNull)
      .authenticationMethod(authenticationMethod.orNull)
      .batchSize(batchSize.orNull)
      .enabled(enabled.map(Boolean.box).orNull)
      .vpcSubnets(vpcSubnets.orNull)
      .maxBatchingWindow(maxBatchingWindow.orNull)
      .vpc(vpc.orNull)
      .startingPosition(startingPosition.orNull)
      .topic(topic.orNull)
      .securityGroup(securityGroup.orNull)
      .build()
}
