package io.burkard.cdk.services.lambda

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnUrl {

  def apply(
    internalResourceId: String,
    authType: String,
    targetFunctionArn: String,
    cors: Option[software.amazon.awscdk.services.lambda.CfnUrl.CorsProperty] = None,
    qualifier: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.lambda.CfnUrl =
    software.amazon.awscdk.services.lambda.CfnUrl.Builder
      .create(stackCtx, internalResourceId)
      .authType(authType)
      .targetFunctionArn(targetFunctionArn)
      .cors(cors.orNull)
      .qualifier(qualifier.orNull)
      .build()
}
