package io.burkard.cdk.services.lambda

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnLayerVersionPermissionProps {

  def apply(
    action: String,
    principal: String,
    layerVersionArn: String,
    organizationId: Option[String] = None
  ): software.amazon.awscdk.services.lambda.CfnLayerVersionPermissionProps =
    (new software.amazon.awscdk.services.lambda.CfnLayerVersionPermissionProps.Builder)
      .action(action)
      .principal(principal)
      .layerVersionArn(layerVersionArn)
      .organizationId(organizationId.orNull)
      .build()
}
