package io.burkard.cdk.services.lakeformation

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnPermissionsProps {

  def apply(
    resource: software.amazon.awscdk.services.lakeformation.CfnPermissions.ResourceProperty,
    dataLakePrincipal: software.amazon.awscdk.services.lakeformation.CfnPermissions.DataLakePrincipalProperty,
    permissions: Option[List[String]] = None,
    permissionsWithGrantOption: Option[List[String]] = None
  ): software.amazon.awscdk.services.lakeformation.CfnPermissionsProps =
    (new software.amazon.awscdk.services.lakeformation.CfnPermissionsProps.Builder)
      .resource(resource)
      .dataLakePrincipal(dataLakePrincipal)
      .permissions(permissions.map(_.asJava).orNull)
      .permissionsWithGrantOption(permissionsWithGrantOption.map(_.asJava).orNull)
      .build()
}
