package io.burkard.cdk.services.iottwinmaker

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnWorkspace {

  def apply(
    internalResourceId: String,
    workspaceId: String,
    role: String,
    s3Location: String,
    description: Option[String] = None,
    tags: Option[Map[String, String]] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.iottwinmaker.CfnWorkspace =
    software.amazon.awscdk.services.iottwinmaker.CfnWorkspace.Builder
      .create(stackCtx, internalResourceId)
      .workspaceId(workspaceId)
      .role(role)
      .s3Location(s3Location)
      .description(description.orNull)
      .tags(tags.map(_.asJava).orNull)
      .build()
}
