package io.burkard.cdk.services.iottwinmaker

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnSceneProps {

  def apply(
    workspaceId: String,
    sceneId: String,
    contentLocation: String,
    capabilities: Option[List[String]] = None,
    description: Option[String] = None,
    tags: Option[Map[String, String]] = None
  ): software.amazon.awscdk.services.iottwinmaker.CfnSceneProps =
    (new software.amazon.awscdk.services.iottwinmaker.CfnSceneProps.Builder)
      .workspaceId(workspaceId)
      .sceneId(sceneId)
      .contentLocation(contentLocation)
      .capabilities(capabilities.map(_.asJava).orNull)
      .description(description.orNull)
      .tags(tags.map(_.asJava).orNull)
      .build()
}
