package io.burkard.cdk.services.iottwinmaker

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnEntityProps {

  def apply(
    workspaceId: String,
    entityName: String,
    entityId: Option[String] = None,
    description: Option[String] = None,
    tags: Option[Map[String, String]] = None,
    components: Option[Map[String, _]] = None,
    parentEntityId: Option[String] = None
  ): software.amazon.awscdk.services.iottwinmaker.CfnEntityProps =
    (new software.amazon.awscdk.services.iottwinmaker.CfnEntityProps.Builder)
      .workspaceId(workspaceId)
      .entityName(entityName)
      .entityId(entityId.orNull)
      .description(description.orNull)
      .tags(tags.map(_.asJava).orNull)
      .components(components.map(_.asJava).orNull)
      .parentEntityId(parentEntityId.orNull)
      .build()
}
