package io.burkard.cdk.services.iot

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnRoleAliasProps {

  def apply(
    roleArn: String,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    credentialDurationSeconds: Option[Number] = None,
    roleAlias: Option[String] = None
  ): software.amazon.awscdk.services.iot.CfnRoleAliasProps =
    (new software.amazon.awscdk.services.iot.CfnRoleAliasProps.Builder)
      .roleArn(roleArn)
      .tags(tags.map(_.asJava).orNull)
      .credentialDurationSeconds(credentialDurationSeconds.orNull)
      .roleAlias(roleAlias.orNull)
      .build()
}
