package io.burkard.cdk.services.imagebuilder.cfnDistributionConfiguration

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object AmiDistributionConfigurationProperty {

  def apply(
    name: Option[String] = None,
    targetAccountIds: Option[List[String]] = None,
    description: Option[String] = None,
    amiTags: Option[Map[String, String]] = None,
    kmsKeyId: Option[String] = None,
    launchPermissionConfiguration: Option[software.amazon.awscdk.services.imagebuilder.CfnDistributionConfiguration.LaunchPermissionConfigurationProperty] = None
  ): software.amazon.awscdk.services.imagebuilder.CfnDistributionConfiguration.AmiDistributionConfigurationProperty =
    (new software.amazon.awscdk.services.imagebuilder.CfnDistributionConfiguration.AmiDistributionConfigurationProperty.Builder)
      .name(name.orNull)
      .targetAccountIds(targetAccountIds.map(_.asJava).orNull)
      .description(description.orNull)
      .amiTags(amiTags.map(_.asJava).orNull)
      .kmsKeyId(kmsKeyId.orNull)
      .launchPermissionConfiguration(launchPermissionConfiguration.orNull)
      .build()
}
