package io.burkard.cdk.services.fsx.cfnVolume

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object OntapConfigurationProperty {

  def apply(
    storageVirtualMachineId: String,
    storageEfficiencyEnabled: String,
    junctionPath: String,
    sizeInMegabytes: String,
    securityStyle: Option[String] = None,
    tieringPolicy: Option[software.amazon.awscdk.services.fsx.CfnVolume.TieringPolicyProperty] = None
  ): software.amazon.awscdk.services.fsx.CfnVolume.OntapConfigurationProperty =
    (new software.amazon.awscdk.services.fsx.CfnVolume.OntapConfigurationProperty.Builder)
      .storageVirtualMachineId(storageVirtualMachineId)
      .storageEfficiencyEnabled(storageEfficiencyEnabled)
      .junctionPath(junctionPath)
      .sizeInMegabytes(sizeInMegabytes)
      .securityStyle(securityStyle.orNull)
      .tieringPolicy(tieringPolicy.orNull)
      .build()
}
