package io.burkard.cdk.services.fsx

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnSnapshotProps {

  def apply(
    name: String,
    volumeId: String,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None
  ): software.amazon.awscdk.services.fsx.CfnSnapshotProps =
    (new software.amazon.awscdk.services.fsx.CfnSnapshotProps.Builder)
      .name(name)
      .volumeId(volumeId)
      .tags(tags.map(_.asJava).orNull)
      .build()
}
