package io.burkard.cdk.services.evidently

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnProjectProps {

  def apply(
    name: String,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    description: Option[String] = None,
    dataDelivery: Option[software.amazon.awscdk.services.evidently.CfnProject.DataDeliveryObjectProperty] = None
  ): software.amazon.awscdk.services.evidently.CfnProjectProps =
    (new software.amazon.awscdk.services.evidently.CfnProjectProps.Builder)
      .name(name)
      .tags(tags.map(_.asJava).orNull)
      .description(description.orNull)
      .dataDelivery(dataDelivery.orNull)
      .build()
}
