package io.burkard.cdk.services.events.targets

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CodePipelineTargetOptions {

  def apply(
    maxEventAge: Option[software.amazon.awscdk.Duration] = None,
    retryAttempts: Option[Number] = None,
    eventRole: Option[software.amazon.awscdk.services.iam.IRole] = None,
    deadLetterQueue: Option[software.amazon.awscdk.services.sqs.IQueue] = None
  ): software.amazon.awscdk.services.events.targets.CodePipelineTargetOptions =
    (new software.amazon.awscdk.services.events.targets.CodePipelineTargetOptions.Builder)
      .maxEventAge(maxEventAge.orNull)
      .retryAttempts(retryAttempts.orNull)
      .eventRole(eventRole.orNull)
      .deadLetterQueue(deadLetterQueue.orNull)
      .build()
}
