package io.burkard.cdk.services.events.cfnConnection

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object OAuthParametersProperty {

  def apply(
    clientParameters: software.amazon.awscdk.services.events.CfnConnection.ClientParametersProperty,
    authorizationEndpoint: String,
    httpMethod: String,
    oAuthHttpParameters: Option[software.amazon.awscdk.services.events.CfnConnection.ConnectionHttpParametersProperty] = None
  ): software.amazon.awscdk.services.events.CfnConnection.OAuthParametersProperty =
    (new software.amazon.awscdk.services.events.CfnConnection.OAuthParametersProperty.Builder)
      .clientParameters(clientParameters)
      .authorizationEndpoint(authorizationEndpoint)
      .httpMethod(httpMethod)
      .oAuthHttpParameters(oAuthHttpParameters.orNull)
      .build()
}
