package io.burkard.cdk.services.events

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object EventBusAttributes {

  def apply(
    eventBusArn: String,
    eventBusPolicy: String,
    eventBusName: String,
    eventSourceName: Option[String] = None
  ): software.amazon.awscdk.services.events.EventBusAttributes =
    (new software.amazon.awscdk.services.events.EventBusAttributes.Builder)
      .eventBusArn(eventBusArn)
      .eventBusPolicy(eventBusPolicy)
      .eventBusName(eventBusName)
      .eventSourceName(eventSourceName.orNull)
      .build()
}
